IF OBJECT_ID('P_PDV_VD_IT_GRP_COMIS_PDV') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_PDV_VD_IT_GRP_COMIS_PDV
	END
 GO 

CREATE PROCEDURE P_PDV_VD_IT_GRP_COMIS_PDV AS
--Criando a tabela temporaria
CREATE TABLE #RsPdv (	
					CD_EMP int,
					CD_FILIAL int,
					CD_VD INT,
					CD_PROD INT,
					CD_GRP INT)

--Inserindo os dados dos clientes na tabela temporaria
INSERT INTO #RsPdv
SELECT   
		1,
		resultado.CD_FILIAL,
		resultado.CD_VD,
		resultado.CD_PROD,
		GRP.CD_GRP                 
	 FROM
         (SELECT  
			DISTINCT PDV_VD_IT.CD_FILIAL,
			PDV_VD_IT.CD_VD,
			PDV_VD_IT.CD_PROD,
			ISNULL(GRP.CD_GRP,0) AS CD_GRP                 
         FROM     
			PDV_VD_IT LEFT OUTER JOIN EST_GRP_COMIS_PDV AS GRP ON       
			PDV_VD_IT.CD_EMP       = GRP.CD_EMP AND
			PDV_VD_IT.CD_GRP_COMIS = GRP.CD_GRP
			INNER JOIN PDV_VD ON
			PDV_VD_IT.CD_EMP = PDV_VD.CD_EMP AND
			PDV_VD_IT.CD_FILIAL = PDV_VD.CD_FILIAL AND
			PDV_VD_IT.CD_VD = PDV_VD.CD_VD AND
			PDV_VD_IT.DT_VD = PDV_VD.DT_VD
         WHERE
			PDV_VD.DT_VD BETWEEN CONVERT(CHAR(10),GETDATE()- 20, 112) AND CONVERT(CHAR(10), GETDATE(), 112)
			AND ISNULL (PDV_VD_IT.CD_GRP_COMIS,0) = 0 ) AS resultado 
			LEFT OUTER JOIN EST_GRP_COMIS_PDV_CPL GRP ON
			resultado.CD_FILIAL=GRP.CD_FILIAL AND
			resultado.CD_PROD=GRP.CD_PROD 
		where
			not GRP.cd_grp is null
			and GRP.cd_grp > 0

--Criando variavel que vai receber o codigo do cliente
DECLARE	@CD_EMP INT
DECLARE	@CD_FILIAL INT
DECLARE @CD_VD INT
DECLARE @CD_PROD INT
DECLARE	@CD_GRP INT

--Criando o cursos de alterao para que possamos alterar cliente a cliente
--assim no iremos bloquear as paginas do banco de dados
--somente o registro que esta sendo alterado, assim o usurio final no vai perceber
--forma mais efeciente de atualizar os clientes sem bloquear os usurios finais
SET NOCOUNT ON
DECLARE Vendas CURSOR FAST_FORWARD FOR SELECT CD_EMP,CD_FILIAL,CD_VD,CD_PROD,CD_GRP FROM #RsPdv
OPEN Vendas
FETCH NEXT FROM Vendas INTO @CD_EMP,@CD_FILIAL,@CD_VD,@CD_PROD,@CD_GRP
WHILE @@FETCH_STATUS=0
	Begin
		UPDATE 
				V
		SET 
			V.CD_GRP_COMIS = @CD_GRP
		FROM 
			PDV_VD_IT V
		WHERE
			V.CD_EMP = @CD_EMP
			AND V.CD_FILIAL = @CD_FILIAL
			AND V.CD_VD = @CD_VD
			AND V.CD_PROD=@CD_PROD 
			
		FETCH NEXT FROM Vendas INTO @CD_EMP,@CD_FILIAL,@CD_VD,@CD_PROD,@CD_GRP
	End

PRINT 'Concludo.'

--Fechando cursos
CLOSE Vendas;
--Desalocando cursos da memoria
DEALLOCATE Vendas;
--Apagando a tabela temporaria
DROP TABLE #RsPdv;